package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class DisputeTypeListResponse(
    val guid: String,
    val message: String,
    val result: DisputeTypeListResponseResult,
    val status: Int
) {

    companion object {
        fun getDisputeTypeListResponseFromJSON(string: String): DisputeTypeListResponse? {
            val json = JSONObject(string)
            val result = DisputeTypeListResponseResult.getDisputeTypeListResponseResultFromJSON(
                json.optJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return result?.let {
                DisputeTypeListResponse(
                    json.optString(URLConstants.RES_PARAM_GUID), json.optString(
                        URLConstants.RES_PARAM_MESSAGE
                    ),
                    result, json.optInt(URLConstants.RES_PARAM_STATUS)
                )
            }
        }
    }
}

data class DisputeTypeListResponseResult(
    val status: String,
    val statusDesc: String,
    val ticketNo: String,
    val upiTransactionRefNo: String,
    val disputeTypeList: List<DisputeType>
) {

    companion object {

        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val TICKET_NO = "ticketNo"
        const val UPI_TXN_REF_NO = "upiTransactionRefNo"
        const val DISPUTE_TYPE_LIST = "disputeTypeList"

        fun getDisputeTypeListResponseResultFromJSON(jsonObject: JSONObject?): DisputeTypeListResponseResult? {
            val disputeTypeListArray = jsonObject?.optJSONArray(DISPUTE_TYPE_LIST)
            return disputeTypeListArray?.let {
                val disputeTypeList = List(it.length()) { index ->
                    DisputeType.getDisputeTypeFromJSON(it.getJSONObject(index))
                }
                DisputeTypeListResponseResult(jsonObject.optString(STATUS), STATUS_DESC,
                    jsonObject.optString(TICKET_NO), jsonObject.optString(UPI_TXN_REF_NO), disputeTypeList)
            }
        }
    }
}

data class DisputeType(
    val reasonCode: String,
    val reasonDesc: String
) {
    companion object {
        const val REASON_CODE = "reasonCode"
        const val REASON_DESC = "reasonDesc"

        fun getDisputeTypeFromJSON(jsonObject: JSONObject): DisputeType {
            return DisputeType(jsonObject.optString(REASON_CODE), jsonObject.optString(REASON_DESC))
        }
    }
}
