package com.payu.upiboltcore.models

import org.json.JSONObject

data class ErrorResponse(
    val status: String,
    val errorCode: String,
    val guid: String,
    val message: String,
) {

    companion object {

        const val STATUS = "status"
        const val ERROR_CODE = "errorCode"
        const val GUID = "guid"
        const val MESSAGE = "message"

        fun getErrorResponseFromJSON(string: String): ErrorResponse {
            val json = JSONObject(string)
            return ErrorResponse(json.optString(STATUS), json.optString(ERROR_CODE),
                json.optString(GUID), json.optString(MESSAGE))
        }
    }
}
