package com.payu.upiboltcore.models

import org.json.JSONObject

data class GetDisputeListRequest(
    val deviceInfo: DeviceInfo,
    val referenceId: String?=null
) {
    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(REFERENCE_ID, referenceId)
        }
    }
}