package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class GetProfileResponse(
    val guid: String,
    val message: String,
    val result: GetProfileResponseResult,
    val status: Int
) {
    companion object {
        fun getProfileResponseFromJSON(string: String): GetProfileResponse {
            val json = JSONObject(string)
            val result = GetProfileResponseResult.getProfileResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return GetProfileResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class GetProfileResponseResult(
    val notificationCount: String,
    val defaultVPAStatus: String,
    val statusDesc: String,
    val userInfo: UserInfo?,
    val vpaAccountDetails : List<AccountInfo?>?
) {
    companion object {
        const val NOTIFICATION_COUNT = "notificationCount"
        const val DEFAULT_VPA_STATUS = "defaultVPAStatus"
        const val STATUS_DESC = "statusDesc"
        const val USER_INFO = "userInfo"
        const val VPA_ACCOUNT_DETAILS = "vpaAccountDetails"

        fun getProfileResponseResultFromJSON(jsonObject: JSONObject): GetProfileResponseResult {
            val userInfo = jsonObject.optJSONObject(USER_INFO)?.let { UserInfo.getUserInfoFromJSON(it) }
            val vpaAccountDetailsListArray = jsonObject.optJSONArray(VPA_ACCOUNT_DETAILS)
            val vpaAccountList = vpaAccountDetailsListArray?.let {
                List(vpaAccountDetailsListArray.length()) { index ->
                    vpaAccountDetailsListArray.optJSONObject(index)?.let { json ->
                        AccountInfo.getAccountInfoFromJSON(json)
                    }
                }
            }
            return GetProfileResponseResult(jsonObject.optString(NOTIFICATION_COUNT),
                jsonObject.optString(DEFAULT_VPA_STATUS), jsonObject.optString(STATUS_DESC),
                userInfo,vpaAccountList)
        }
    }
}
data class VpaAccountDetails(
    val status: String,
    val accountId: String,
    val statusDesc: String,
    val accountList: List<AccountInfo>?,
    val virtualAddress: String,
    val collectLimit: String,
    val appConfiguration: AppConfiguration?,
    val defaultVPAStatus: String
) {
    companion object {
        const val STATUS = "status"
        const val ACCOUNT_ID = "accountId"
        const val STATUS_DESC = "statusDesc"
        const val ACCOUNT_LIST = "accountInfo"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val COLLECT_LIMIT = "collectLimit"
        const val APP_CONFIGURATION = "appConfiguration"
        const val DEFAULT_VPA_STATUS = "defaultVPAStatus"

        fun getVpaAccountDetailsFromJSON(jsonObject: JSONObject): VpaAccountDetails {
            val accountListArray = jsonObject.optJSONArray(ACCOUNT_LIST)
            val accountList = if (accountListArray != null && accountListArray.length() > 0) {
                List(accountListArray.length()) { index ->
                    accountListArray.getJSONObject(index).let { json ->
                        AccountInfo.getAccountInfoFromJSON(json)
                    }
                }
            } else null

            val appConfiguration = jsonObject.optJSONObject(APP_CONFIGURATION)?.let {
                AppConfiguration.getAppConfigurationFromJSON(it)
            }
            return VpaAccountDetails(
                jsonObject.optString(STATUS), jsonObject.optString(ACCOUNT_ID),
                jsonObject.optString(STATUS_DESC), accountList, jsonObject.optString(VIRTUAL_ADDRESS)
                , jsonObject.optString(COLLECT_LIMIT)
                , appConfiguration
                , jsonObject.optString(DEFAULT_VPA_STATUS)
            )
        }
    }
}
data class AppConfiguration(
    val customerMenuList: List<CustomerMenu?>?,
    val disableAadhaarPay: String,
    val disableDynamicPinPad: String,
    val disableFingerprint: String,
    val dynamicKeyPinPadFlag: String,
    val enableDebitCapping: String,
    val enableNotificationMessage: String,
    val fingerprintFlag: String,
    val maxVpaCreationLimit: Int,
    val p2pMaxCollectAmount: String,
    val p2pMaxPayAmount: String,
    val sessionTime: Int,
    val tapzoEnable: String
) {
    companion object {
        const val CUSTOMER_MENU_LIST = "customerMenuList"
        const val DISABLE_AADHAR_PAY = "disableAadhaarPay"
        const val DISABLE_DYNAMIC_PIN_PAD = "disableDynamicPinPad"
        const val DISABLE_FINGER_PRINT = "disableFingerprint"
        const val DYNAMIC_KEY_PIN_PAD_FLAG = "dynamicKeyPinPadFlag"
        const val ENABLE_DEBIT_CAPPING = "enableDebitCapping"
        const val ENABLE_NOTIFICATION_MESSAGE = "enableNotificationMessage"
        const val FINGER_PRINT_FLAG = "fingerprintFlag"
        const val MAX_VPA_CREATION_LIMIT = "maxVpaCreationLimit"
        const val P2P_MAX_COLLECTION_AMOUNT = "p2pMaxCollectAmount"
        const val P2P_MAX_PAY_AMOUNT = "p2pMaxPayAmount"
        const val SESSION_TIME = "sessionTime"
        const val TEPZOENABLE = "tapzoEnable"

        fun getAppConfigurationFromJSON(jsonObject: JSONObject): AppConfiguration {
            val cutomerMenuListArray = jsonObject.optJSONArray(CUSTOMER_MENU_LIST)
            val customerMenu = cutomerMenuListArray?.let {
                List(cutomerMenuListArray.length()) { index ->
                    cutomerMenuListArray.optJSONObject(index)?.let { json ->
                        CustomerMenu.getCustomerMenuFromJSON(json)
                    }
                }
            }
                return AppConfiguration(customerMenu,
                    jsonObject.optString(DISABLE_AADHAR_PAY),
                    jsonObject.optString(DISABLE_DYNAMIC_PIN_PAD),
                    jsonObject.optString(DISABLE_FINGER_PRINT),
                    jsonObject.optString(DYNAMIC_KEY_PIN_PAD_FLAG)
                    , jsonObject.optString(ENABLE_DEBIT_CAPPING)
                    , jsonObject.optString(ENABLE_NOTIFICATION_MESSAGE)
                    , jsonObject.optString(FINGER_PRINT_FLAG)
                    , jsonObject.optInt(MAX_VPA_CREATION_LIMIT)
                    , jsonObject.optString(P2P_MAX_COLLECTION_AMOUNT)
                    , jsonObject.optString(P2P_MAX_PAY_AMOUNT)
                    , jsonObject.optInt(SESSION_TIME)
                    , jsonObject.optString(TEPZOENABLE )
                )
        }
    }

}
data class CustomerMenu(
    val id: String,
    val name: String,
    val order: String,
    val status: String
){
    companion object {
        const val ID = "id"
        const val NAME = "name"
        const val ORDER = "order"
        const val STATUS = "status"

        fun getCustomerMenuFromJSON(jsonObject: JSONObject): CustomerMenu {

            return CustomerMenu(
                jsonObject.optString(ID),
                jsonObject.optString(NAME),
                jsonObject.optString(ORDER),
                jsonObject.optString(STATUS)
            )
        }

    }
}