package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class InitiateMPinResponse(
    val guid: String,
    val message: String,
    val result: InitiateMPinResponseResult,
    val status: Int
) {
    companion object {
        fun getInitMPinResponseFromJSON(string: String): InitiateMPinResponse {
            val json = JSONObject(string)
            val result = InitiateMPinResponseResult.getInitMPinResponseFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return InitiateMPinResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class InitiateMPinResponseResult(
    val upiTranRefNo: String,
    val npciTranId: String,
    val otpNpciTranId: String,
    val deviceInfo: DeviceInfo?,
    val payerType: PayerType?,
    val transactionNote: String,
    val refUrl: String,
    val credential: Credential?,
    val status: String,
    val statusDesc: String
) {
    companion object {
        const val UPI_TRAN_REF_NO = "upiTranRefNo"
        const val NPCI_TRAN_ID = "npciTransactionId"
        const val OTP_NPCI_TRAN_ID = "otpNpciTransactionId"
        const val DEVICE_INFO = "deviceInfo"
        const val PAYER_TYPE = "payerType"
        const val TRANSACTION_NOTE = "transactionNote"
        const val REF_URL = "refUrl"
        const val CREDENTIAL = "credential"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"

        fun getInitMPinResponseFromJSON(jsonObject: JSONObject): InitiateMPinResponseResult {
            val deviceInfo = jsonObject.optJSONObject(DEVICE_INFO)?.let { DeviceInfo.getDeviceInfoFromJSON(it) }
            val payerType = jsonObject.optJSONObject(PAYER_TYPE)?.let { PayerType.getPayerTypeFromJSON(it) }
            val credential = jsonObject.optJSONObject(CREDENTIAL)?.let { Credential.getCredentialFromJSON(it) }

            return InitiateMPinResponseResult(
                jsonObject.optString(UPI_TRAN_REF_NO),
                jsonObject.optString(NPCI_TRAN_ID),
                jsonObject.optString(OTP_NPCI_TRAN_ID),
                deviceInfo, payerType,
                jsonObject.optString(TRANSACTION_NOTE),
                jsonObject.optString(REF_URL),
                credential,
                jsonObject.optString(STATUS),
                jsonObject.optString(STATUS_DESC)
            )
        }
    }

    fun getJSONObject(maskPi: Boolean = false, logInfo: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(UPI_TRAN_REF_NO, upiTranRefNo)
            put(NPCI_TRAN_ID, npciTranId)
            put(OTP_NPCI_TRAN_ID, otpNpciTranId)
            if (logInfo.not())
                put(DEVICE_INFO, deviceInfo?.getJSONObject(maskPi))
            put(PAYER_TYPE, payerType?.getJSONObject(maskPi))
            put(TRANSACTION_NOTE, transactionNote)
            put(REF_URL, refUrl)
            if (logInfo.not())
                put(CREDENTIAL, credential)
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
        }
    }
}
