package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class ListKeysResponse(
    val guid: String,
    val message: String,
    val result: ListKeysResponseResult,
    val status: Int
) {
    companion object {
        fun getListKeysResponseFromJSON(string: String): ListKeysResponse {
            val json = JSONObject(string)
            val result = ListKeysResponseResult.getListKeysResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return ListKeysResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class ListKeysResponseResult(
    val refId: String,
    val refUrl: String,
    val txnId: String,
    var xmlResp: String
) {
    companion object {
        const val REF_ID = "refId"
        const val REF_URL = "refUrl"
        const val TXN_ID = "txnId"
        const val XML_RESP = "xmlResp"

        fun getListKeysResponseResultFromJSON(jsonObject: JSONObject): ListKeysResponseResult {
            return ListKeysResponseResult(
                jsonObject.optString(REF_ID), jsonObject.optString(REF_URL),
                jsonObject.optString(TXN_ID), jsonObject.optString(XML_RESP)
            )
        }
    }
}