package com.payu.upiboltcore.models

import org.json.JSONObject

data class MakePaymentRequest(
    val amount: String,
    val credential: Credential,
    val deviceInfo: DeviceInfo,
    val expiryTime: String? = "0",
    val initiationMode: String,
    val merchantDetails: MerchantDetails?=null,
    val npciTranId: String,
    val payeeType: PayeeType?=null,
    val payerType: PayerType,
    val refId: String?=null,
    val refUrl: String?=null,
    val transactionNote: String?=null,
    val txnId: String,
    val upiLiteEnabled: Boolean = false,
    val purpose: String,
    val referenceId: String?=null
) {
    companion object {
        const val AMOUNT = "amount"
        const val DEVICE_INFO = "deviceInfo"
        const val CREDENTIAL = "credential"
        const val EXPIRY_TIME = "expiryTime"
        const val INITIANTION_MODE = "initiationMode"
        const val MERCHANT_DETAILS = "merchantDetails"
        const val NPCI_TXN_ID = "npciTranId"
        const val PAYEE_TYPE = "payeeType"
        const val PAYER_TYPE = "payerType"
        const val REF_ID = "refId"
        const val REF_URL = "refUrl"
        const val TXN_NOTE = "transactionNote"
        const val TXN_ID = "txnId"
        const val UPILITE_ENABLED = "upiLiteEnabled"
        const val PURPOSE = "purpose"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(AMOUNT, amount)
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(CREDENTIAL, credential.getJSONObject())
            put(EXPIRY_TIME, expiryTime)
            put(INITIANTION_MODE,initiationMode)
            put(MERCHANT_DETAILS, merchantDetails?.getJSONObject())
            put(NPCI_TXN_ID, npciTranId)
            put(PAYEE_TYPE, payeeType?.getJSONObject())
            put(PAYER_TYPE, payerType.getJSONObject())
            put(REF_ID, refId)
            put(REF_URL, refUrl)
            put(TXN_NOTE, transactionNote)
            put(TXN_ID, txnId)
            put(UPILITE_ENABLED, upiLiteEnabled)
            put(PURPOSE, purpose)
            put(REFERENCE_ID, referenceId)
        }
    }
}