package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

class MakePaymentResponse(
    val guid: String,
    val message: String,
    val result: MakePaymentResponseResult,
    val status: Int
) {
    companion object {
        fun getInitMPinResponseFromJSON(string: String): MakePaymentResponse {
            val json = JSONObject(string)
            val result = MakePaymentResponseResult.getMakePaymentResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return MakePaymentResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class MakePaymentResponseResult(
    val accountId: String,
    val amount: String,
    val approvalNumber: String,
    val custRefNo: Long,
    val errorCode: String,
    val npciTransId: String,
    val payType: String,
    val payeeVPA: String,
    val payerVPA: String,
    val prRespCode: String,
    val refId: String,
    val responseCode: String,
    val status: String,
    val statusDesc: String,
    val txnAuthDate: String,
    val upiTransRefNo: String
) {
    companion object {
        const val ACCOUNT_ID = "accountId"
        const val AMOUNT = "amount"
        const val APPROVAL_NUMBER = "approvalNumber"
        const val CUST_REF_NO = "custRefNo"
        const val ERROR_CODE = "errorCode"
        const val NPCI_TRANS_ID = "npciTransId"
        const val PAY_TYPE = "payType"
        const val PAYEE_VPA = "payeeVPA"
        const val PAYER_VPA = "payerVPA"
        const val PR_RESP_CODE = "prRespCode"
        const val REF_ID = "refId"
        const val RESPONSE_CODE = "responseCode"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val TXN_AUTH_DATE = "txnAuthDate"
        const val UPI_TRANS_REF_NO = "upiTransRefNo"

        fun getMakePaymentResponseResultFromJSON(jsonObject: JSONObject): MakePaymentResponseResult {
            return MakePaymentResponseResult(
                jsonObject.optString(ACCOUNT_ID), jsonObject.optString(AMOUNT),
                jsonObject.optString(APPROVAL_NUMBER), jsonObject.optLong(CUST_REF_NO),
                jsonObject.optString(ERROR_CODE), jsonObject.optString(NPCI_TRANS_ID),
                jsonObject.optString(PAY_TYPE), jsonObject.optString(PAYEE_VPA),
                jsonObject.optString(PAYER_VPA), jsonObject.optString(PR_RESP_CODE),
                jsonObject.optString(REF_ID), jsonObject.optString(RESPONSE_CODE),
                jsonObject.optString(STATUS), jsonObject.optString(STATUS_DESC),
                jsonObject.optString(TXN_AUTH_DATE), jsonObject.optString(UPI_TRANS_REF_NO))
        }
    }
}