package com.payu.upiboltcore.models

import org.json.JSONObject

data class MerchantDetails(
    val accountType: String? = null,
    val brandName: String? = null,
    val franchiseName: String? = null,
    val ifsc: String? = null,
    val iin: Int? = null,
    val isVerified: String? = null,
    val legalName: String? = null,
    val merchantCode: Int? = null,
    val merchantId: String? = null,
    val merchantType: String? = null,
    val ownershipType: String? = null,
    val storeId: Int? = null,
    val subCategoryCode: Int? = null,
    val terminalId: Int? = null,
    val msid: String? = null,
    val mtid: String? = null
) {

    companion object {
        const val ACCOUNT_TYPE = "accountType"
        const val BRAND_NAME = "brandName"
        const val FRANCHISE_NAME = "franchiseName"
        const val IFSC = "ifsc"
        const val IIN = "iin"
        const val IS_VERIFIED = "isVerified"
        const val LEGAL_NAME = "legalName"
        const val MERCHANT_CODE = "merchantCode"
        const val MERCHANT_ID = "merchantId"
        const val MERCHANT_TYPE = "merchantType"
        const val OWNERSHIP_TYPE = "ownershipType"
        const val STORE_ID = "storeId"
        const val SUB_CATEGORY_CODE = "subCategoryCode"
        const val TERMINAL_ID = "terminalId"
        const val MSID = "msid"
        const val MTID = "mtid"

        fun getMerchantDetailsFromJSON(jsonObject: JSONObject): MerchantDetails {
            return MerchantDetails(
                jsonObject.optString(ACCOUNT_TYPE), jsonObject.optString(BRAND_NAME),
                jsonObject.optString(FRANCHISE_NAME), jsonObject.optString(IFSC),
                jsonObject.optInt(IIN), jsonObject.optString(IS_VERIFIED),
                jsonObject.optString(LEGAL_NAME), jsonObject.optInt(MERCHANT_CODE),
                jsonObject.optString(MERCHANT_ID), jsonObject.optString(MERCHANT_TYPE),
                jsonObject.optString(OWNERSHIP_TYPE), jsonObject.optInt(STORE_ID),
                jsonObject.optInt(SUB_CATEGORY_CODE), jsonObject.optInt(TERMINAL_ID),
                jsonObject.optString(MSID), jsonObject.optString(MTID)
            )
        }


    }
    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(ACCOUNT_TYPE, accountType)
            put(BRAND_NAME, brandName)
            put(FRANCHISE_NAME, franchiseName)
            put(IFSC, ifsc)
            put(IIN, iin)
            put(IS_VERIFIED, isVerified)
            put(LEGAL_NAME, legalName)
            put(MERCHANT_CODE, merchantCode)
            put(MERCHANT_ID, merchantId)
            put(MERCHANT_TYPE, merchantType)
            put(OWNERSHIP_TYPE, ownershipType)
            put(STORE_ID, storeId)
            put(SUB_CATEGORY_CODE, subCategoryCode)
        }
    }
}