package com.payu.upiboltcore.models

import com.payu.commonmodelssdk.enums.PluginType
import com.payu.commonmodelssdk.listeners.OTPVerificationInterface
import com.payu.commonmodelssdk.listeners.ApiFailedCallback
import com.payu.upiboltcore.utils.Utils

data class PayUPluginInitParams(
    val mKey: String,
    val appId: String,
    val subscriptionId: String,
    private val phone: String,
    val email: String? = null,
    val refId: String,
    val initTxnId: String,
    val isProduction: Boolean = true,
    val bankIds: List<PluginType>,
    val otpVerificationInterface: OTPVerificationInterface? = null,
    val apiFailureCallback: ApiFailedCallback? = null
) {
    fun getPhone() = Utils.formatMobileNumber(phone)
}
