package com.payu.upiboltcore.models

import org.json.JSONObject

data class PayeeType(
    val ifsc: String? = null,
    val mcc: String? = null,
    val merchantName: String? = null,
    val mobileNo: String? = null,
    val name: String? = null,
    val virtualAddress: String? = null,
    val vpaType: String? = "VA",
) {
    companion object {
        const val IFSC = "ifsc"
        const val MCC = "mcc"
        const val MERCHANT_NAME = "merchantName"
        const val MOBILE_NO = "mobileNo"
        const val NAME = "name"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val VPA_TYPE = "vpaType"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(IFSC, ifsc)
            put(MCC, mcc)
            put(MERCHANT_NAME, merchantName)
            put(MOBILE_NO, mobileNo)
            put(NAME, name)
            put(VIRTUAL_ADDRESS, virtualAddress)
            put(VPA_TYPE, vpaType)
        }
    }
}