package com.payu.upiboltcore.models

import org.json.JSONObject

data class RaiseDisputeRequest(
    val complaintInfo: ComplaintInfo,
    val deviceInfo: DeviceInfo,
    val referenceId: String?=null
) {
    companion object {
        const val COMPLAINT_INFO = "complaintInfo"
        const val DEVICE_INFO = "deviceInfo"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(COMPLAINT_INFO, complaintInfo.getJSONObject())
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(REFERENCE_ID, referenceId)
        }
    }
}