package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class RaiseDisputeResponse(
    val guid: String,
    val message: String,
    val result: RaiseDisputeResponseResult,
    val status: Int
) {
    companion object {
        fun getRaiseDisputeResponseFromJSON(string: String): RaiseDisputeResponse {
            val json = JSONObject(string)
            val result = RaiseDisputeResponseResult.getRaiseDisputeResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return RaiseDisputeResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class RaiseDisputeResponseResult(
    val errCode: String,
    val status: String,
    val statusDesc: String,
    val complaintInfo: ComplaintInfo
) {
    companion object {
        const val ERR_CODE = "errCode"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val COMPLAINT_INFO = "complaintInfo"

        fun getRaiseDisputeResponseResultFromJSON(jsonObject: JSONObject): RaiseDisputeResponseResult {
            val complaintInfo = ComplaintInfo.getComplainInfoFromJSON(jsonObject.getJSONObject(
                COMPLAINT_INFO))
            return RaiseDisputeResponseResult(jsonObject.optString(ERR_CODE), jsonObject.optString(
                STATUS), jsonObject.optString(STATUS_DESC), complaintInfo)
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(ERR_CODE, errCode)
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
            put(COMPLAINT_INFO, complaintInfo.getJSONObject())
        }
    }
}