package com.payu.upiboltcore.models

import org.json.JSONObject

data class RegisterVPARequest(
    val customerEmail: String? = null,
    val deviceInfo: DeviceInfo,
    val rvh: String?=null,
    val userInfo: UserInfo,
    val virtualAddress: String?=null,
    val pspRespRefNo: String?=null,
    val referenceId: String?=null
) {
    companion object {
        const val CUSTOMER_EMAIL = "customerEmail"
        const val DEVICE_INFO = "deviceInfo"
        const val RVH = "rvh"
        const val USER_INFO = "userInfo"
        const val VPA = "virtualAddress"
        const val PSP_RESP_REF_NUM = "pspRespRefNo"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(CUSTOMER_EMAIL, customerEmail)
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(RVH, rvh)
            put(USER_INFO, userInfo.getJSONObject())
            put(VPA, virtualAddress)
            put(PSP_RESP_REF_NUM, pspRespRefNo)
            put(REFERENCE_ID, referenceId)
        }
    }
}