package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import com.payu.upiboltcore.utils.Utils
import org.json.JSONObject

data class SetMPinResponse(
    val guid: String,
    val message: String,
    val result: SetMPinResponseResult,
    val status: Int
) {
    companion object {
        fun getSetMPinResponseFromJSON(string: String): SetMPinResponse {
            val json = JSONObject(string)
            val result = SetMPinResponseResult.getSetMPinResponseFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return SetMPinResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class SetMPinResponseResult(
    val accountId: String,
    val npciTransId: String,
    val pspRefNo: String,
    val status: String,
    val statusDesc: String
) {
    companion object {
        const val ACCOUNT_ID = "accountId"
        const val NPCI_TRANS_ID = "npciTransId"
        const val PSP_REF_NO = "pspRefNo"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"

        fun getSetMPinResponseFromJSON(jsonObject: JSONObject): SetMPinResponseResult {
            return SetMPinResponseResult(
                jsonObject.optString(ACCOUNT_ID),
                jsonObject.optString(NPCI_TRANS_ID),
                jsonObject.optString(PSP_REF_NO),
                jsonObject.optString(STATUS),
                jsonObject.optString(STATUS_DESC)
            )
        }
    }

    fun getJSONObject(maskPi: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(
                ACCOUNT_ID,
                if (maskPi)
                    Utils.getMaskedString(accountId)
                else
                    accountId
            )
            put(NPCI_TRANS_ID, npciTransId)
            put(PSP_REF_NO, pspRefNo)
            put(NPCI_TRANS_ID, npciTransId)
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
        }
    }
}