package com.payu.upiboltcore.models

import org.json.JSONObject

data class UPITokenRequest(
    val credDataValue: String,
    val credSubType: String,
    val transactionId: String,
    val txnType: String,
    val referenceId: String?=null
) {
    companion object {
        const val CRED_DATA_VALUE = "credDataValue"
        const val CRED_SUB_TYPE = "credSubType"
        const val TXN_ID = "transactionId"
        const val TXN_TYPE = "txnType"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(CRED_DATA_VALUE, credDataValue)
            put(CRED_SUB_TYPE, credSubType)
            put(TXN_ID, transactionId)
            put(TXN_TYPE, txnType)
            put(REFERENCE_ID, referenceId)
        }
    }
}

