package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class UPITokenResponse(
    val message: String,
    val result: UPITokenResult,
    val status: Int
) {

    companion object {

        const val TOKEN = "token"
        const val TXN_ID = "txnId"

        fun getUPITokenResponseFromJSON(response: String): UPITokenResponse {
            val json = JSONObject(response)
            val resultJson = json.optJSONObject(URLConstants.RES_PARAM_RESULT)
            val result = UPITokenResult(resultJson?.optString(TOKEN), resultJson?.optString(TXN_ID))
            return UPITokenResponse(json.optString(URLConstants.RES_PARAM_MESSAGE), result, json.optInt(
                URLConstants.RES_PARAM_STATUS))
        }
    }
}

data class UPITokenResult(
    val token: String?,
    val txnId: String?
)