package com.payu.upiboltcore.models

import com.payu.upiboltcore.utils.Utils
import org.json.JSONObject

data class UserInfo(
    val accountId: String? = null, // alt - accId
    val defaultVPAStatus: Boolean? = null, // alt - defVPAStatus
    val isMerchant: Boolean? = null,
    val name: String? = null,
    val showMerchant: Boolean? = null,
    val virtualAddress: String? = null,
    val defaultFlag: String? = null,
    val secretDetails: SecretDetails? = null,
    val custid: String? = null,
    val accountNo: String? = null,
    val ifscCode: String? = null,
    val accountType: String? = null,
    val iin: String? = null,
    val bankId: String? = null,
    val bankFormat: String? = null,
    val mpinFlag: Boolean? = null
) {

    companion object {

        const val ACCOUNT_ID = "accountId"
        const val DEF_VPA_STATUS = "defaultVPAStatus"
        const val IS_MERCHANT = "isMerchant"
        const val NAME = "name"
        const val SHOW_MERCHANT = "showMerchant"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val DEFAULT_FLAG = "defaultFlag"
        const val SECRET_DETAILS = "secretDetails"
        const val CUST_ID = "custid"
        const val ACC_ID = "accId"
        const val ACCOUNT_NO = "accountNo"
        const val IFSC_CODE = "ifscCode"
        const val ACCOUNT_TYPE = "accountType"
        const val IIN = "iin"
        const val BANK_ID = "bankId"
        const val BANK_FORMAT = "bankFormat"
        const val MPIN_FLAG = "mpinFlag"

        fun getUserInfoFromJSON(json: JSONObject): UserInfo {
            val secretDetails = json.optJSONObject(SECRET_DETAILS)?.let { SecretDetails.getSecretDetailsFromJSON(it) }
            return UserInfo(
                if(json.optString(ACCOUNT_ID).isNullOrEmpty().not()) {
                    json.optString(ACCOUNT_ID)
                } else {
                    json.optString(ACC_ID)
                }, json.optBoolean(DEF_VPA_STATUS),
                json.optBoolean(IS_MERCHANT), json.optString(NAME), json.optBoolean(SHOW_MERCHANT),
                json.optString(VIRTUAL_ADDRESS), json.optString(DEFAULT_FLAG), secretDetails,
                json.optString(CUST_ID), json.optString(ACCOUNT_NO), json.optString(IFSC_CODE),
                json.optString(ACCOUNT_TYPE), json.optString(IIN), json.optString(BANK_ID),
                json.optString(BANK_FORMAT), json.optBoolean(MPIN_FLAG)
            )
        }
    }

    fun getJSONObject(maskPi: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(
                ACCOUNT_ID,
                if (maskPi)
                    Utils.getMaskedString(accountId)
                else
                    accountId
            )
            put(DEF_VPA_STATUS, defaultVPAStatus)
            put(IS_MERCHANT, isMerchant)
            put(NAME, name)
            put(SHOW_MERCHANT, showMerchant)
            put(
                VIRTUAL_ADDRESS,
                if (maskPi)
                    Utils.getMaskedString(virtualAddress)
                else
                    virtualAddress
            )
            put(DEFAULT_FLAG, defaultFlag)
            if (maskPi.not())
                put(SECRET_DETAILS, secretDetails?.getJSONObject())
            put(CUST_ID, custid)
            put(
                ACC_ID, if (maskPi)
                    Utils.getMaskedString(accountId)
                else
                    accountId
            )
            put(ACCOUNT_NO, accountNo)
            put(IFSC_CODE, ifscCode)
            put(ACCOUNT_TYPE, accountType)
            put(IIN, iin)
            put(BANK_ID, bankId)
            put(BANK_FORMAT, bankFormat)
            put(MPIN_FLAG, mpinFlag)
        }
    }
}

data class SecretDetails(
    val quesId: String,
    val secretAnswer: String
) {
    companion object {
        const val QUES_ID = "quesId"
        const val SECRET_ANSWER = "secretAnswer"

        fun getSecretDetailsFromJSON(json: JSONObject): SecretDetails {
            return SecretDetails(json.optString(QUES_ID), json.optString(SECRET_ANSWER))
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(QUES_ID, quesId)
            put(SECRET_ANSWER, secretAnswer)
        }
    }
}