package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

class ValidateOTPResponse(
    val guid: String,
    val message: String,
    val result: ValidateOTPResponseResult,
    val status: Int
) {
    companion object {
        fun getValidateOTPResponseFromJSON(string: String): ValidateOTPResponse {
            val json = JSONObject(string)
            val result = ValidateOTPResponseResult.getValidateOTPResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return ValidateOTPResponse(
                json.optString(URLConstants.RES_PARAM_GUID),
                json.optString(URLConstants.RES_PARAM_MESSAGE),
                result,
                json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class ValidateOTPResponseResult(
    val isExistingUser: Boolean? = null,
    val isOtpVerified: Boolean? = null,
    val isCustomerActive: Boolean? = null,
    val registrationToken: ValidateOTPRegistrationToken? = null
) {
    companion object {
        const val IS_EXISTING_USER = "isExistingUser"
        const val IS_OTP_VERIFIED = "isOtpVerified"
        const val IS_CUSTOMER_ACTIVE = "isCustomerActive"
        const val REGISTRATION_TOKEN = "registrationToken"

        fun getValidateOTPResponseResultFromJSON(jsonObject: JSONObject): ValidateOTPResponseResult {
            val regToken = jsonObject.optJSONObject(REGISTRATION_TOKEN)?.let {
                ValidateOTPRegistrationToken.getValidateOTPRegistrationTokenFromJSON(it)
            }
            return ValidateOTPResponseResult(
                jsonObject.optBoolean(IS_EXISTING_USER), jsonObject.optBoolean(IS_OTP_VERIFIED),
                jsonObject.optBoolean(IS_CUSTOMER_ACTIVE), regToken
            )
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(IS_OTP_VERIFIED, isOtpVerified)
            put(IS_CUSTOMER_ACTIVE, isCustomerActive)
            put(IS_EXISTING_USER, isExistingUser)
            put(REGISTRATION_TOKEN, registrationToken)
        }
    }
}

data class ValidateOTPRegistrationToken(
    val id: String? = null
) {
    companion object {
        const val ID = "id"

        fun getValidateOTPRegistrationTokenFromJSON(jsonObject: JSONObject): ValidateOTPRegistrationToken {
            return ValidateOTPRegistrationToken(jsonObject.optString(ID))
        }
    }
}