package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class VerifyServerGenIDResponse(
    val guid: String,
    val message: String,
    val result: VerifyServerGenIDResult,
    val status: Int
) {

    companion object {
        fun getVerifyServerGenIDResponseFromJSON(string: String): VerifyServerGenIDResponse {
            val json = JSONObject(string)
            val result = VerifyServerGenIDResult.getVerifyServerGenIDResultResponseFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return VerifyServerGenIDResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class VerifyServerGenIDResult(
    val deviceInfo: DeviceInfo,
    val servGenId: String,
    val errcode: String,
    val status: String,
    val statusDesc: String,
) {

    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val SERVER_GEN_ID = "servGenId"
        const val ERROR_CODE = "errcode"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"

        fun getVerifyServerGenIDResultResponseFromJSON(json: JSONObject): VerifyServerGenIDResult {
            val deviceInfo = DeviceInfo.getDeviceInfoFromJSON(json.getJSONObject(DEVICE_INFO))
            return VerifyServerGenIDResult(
                deviceInfo,
                json.optString(SERVER_GEN_ID),
                json.optString(ERROR_CODE),
                json.optString(STATUS),
                json.optString(STATUS_DESC))
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo)
            put(SERVER_GEN_ID, servGenId)
            put(ERROR_CODE, errcode)
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
        }
    }
}