package com.payu.upiboltcore.npci

import android.content.Context
import android.util.Log
import com.payu.commonmodelssdk.constants.CLConstant
import com.payu.commonmodelssdk.constants.KibanaConstants
import com.payu.commonmodelssdk.constants.PayUUpiConstant
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.upiboltcore.constants.UPIConstants
import com.payu.upiboltcore.models.ListKeysResponse
import com.payu.upiboltcore.network.NPCIRepository
import com.payu.upiboltcore.utils.AnalyticsUtils
import com.payu.upiboltcore.utils.Utils
import org.json.JSONObject
import org.npci.upi.security.services.CLServices
import java.util.UUID

class ListKeysPayloadManager(
    private val npciRepository: NPCIRepository,
    private val clServices: CLServices,
) {

    fun fetchListKeysPayload(
        context: Context,
        onSuccess: (payload: ListKeysResponse) -> Unit,
        onFailure: (errorCode: Int, errorMessage: String) -> Unit
    ) {
        DeviceInfoManager.deviceInfo?.run {
            val listKeysChallenge =
                NPCIUtils.getChallenge(UPIConstants.CHALLENGE_TYPE_INITIAL, clServices)
            val listKeysDataValue = "$deviceId|$appName|$mobileNo|$listKeysChallenge"

            Log.d("CL_Logs_SDK_challenge","$listKeysChallenge, $listKeysDataValue")
            val referenceID = UUID.randomUUID().toString()
            val startTime = System.currentTimeMillis()
            val txnId = Utils.getUniqueTxnId()

            AnalyticsUtils.logKibana(
                context,
                PayUUpiConstant.PAYU_LIST_KEYS,
                JSONObject().apply {
                    put(KibanaConstants.TXN_ID, txnId)
                }.toString(),
                false, refType = PayUUpiConstant.PLUGIN_CORE_REQUEST,
                referenceId = referenceID
            )

            npciRepository.getListKeys(
                listKeysDataValue,
                UPIConstants.CHALLENGE_TYPE_INITIAL.uppercase(),
                txnId, referenceID,
                object :
                    ApiBaseCallback {
                    override fun onApiSuccess(response: Any) {
                        val payload = response as ListKeysResponse
                        AnalyticsUtils.logKibana(
                            context,
                            PayUUpiConstant.PAYU_LIST_KEYS,
                            JSONObject().apply {
                                put(KibanaConstants.TXN_ID, payload.result.txnId)
                            }.toString(),
                            false, refType = PayUUpiConstant.PLUGIN_CORE_RESPONSE,
                            time = Utils.getTimeDifferenceInMilliSeconds(startTime),
                            referenceId = referenceID,
                            status = CLConstant.PAYU_EVENT_SUCCESS
                        )
                        onSuccess.invoke(payload)
                    }

                    override fun onApiError(errorCode: Int, errorMessage: String) {
                        AnalyticsUtils.logKibana(
                            context,
                            PayUUpiConstant.PAYU_LIST_KEYS,
                            errorMessage,
                            true, refType = PayUUpiConstant.PLUGIN_CORE_RESPONSE,
                            time = Utils.getTimeDifferenceInMilliSeconds(startTime),
                            referenceId = referenceID,
                            code = errorCode.toString(),
                            status = CLConstant.PAYU_EVENT_FAILURE
                        )
                        onFailure.invoke(errorCode, errorMessage)
                    }
                }
            )
        }
    }
}