package com.payu.upiboltcore.constants

class UPIConstants {

    companion object {

        const val SP_FILE_NAME = "PayUPluginSP"

        const val CHALLENGE_TYPE_INITIAL = "initial"
        const val CHALLENGE_TYPE_ROTATE = "rotate"

        const val RESPONSE_STATUS_SUCCESS = "S"
        const val RESPONSE_STATUS_FAILURE = "F"
        const val DEVICE_STATUS_DR = "DR"
        const val DEVICE_STATUS_DN = "DN"
        const val SIM_STATUS_SNN = "SNN"
        const val SIM_STATUS_SNM = "SNM"
        const val SMS_NOT_RECEIVED_STATUS = "SN"
        const val SMS_RECEIVED_STATUS = "SS"

        const val DEVICE_TYPE_MOB = "MOB"

        const val UPI_TOKEN_PREF_KEY = "pref_upi_token"
        const val LIST_KEYS_PREF_KEY = "pref_list_keys"
        const val UPI_TOKEN_ALIAS = "enc_upi_token"
        const val UPI_TOKEN_CREATED_TIME_KEY = "upi_token_created_time"
        const val UPI_TOKEN_EXPIRY_DAYS = 26
        const val UPI_TOKEN_TXN_TYPE = "GET_TOKEN"
        const val LIST_KEYS_TXN_TYPE = "LIST_KEYS"

        const val ACTION_SENT = "SMS_SENT"
        const val ACTION_DELIVERED = "SMS_DELIVERED"
        const val SMS_VERIFICATION_TIMEOUT_MILLIS = (60 * 1000).toLong()
        const val SMS_VERIFICATION_CHECK_INTERVAL_MILLIS = (5 * 1000).toLong()

        const val CREDENTIAL_KEY_CODE = "NPCI"
        const val CREDENTIAL_FORMAT_1 = "FORMAT1"
        const val CREDENTIAL_FORMAT_2 = "FORMAT2"
        const val CREDENTIAL_FORMAT_3 = "FORMAT3"
        const val CREDENTIAL_KEY_TYPE = "type"
        const val CREDENTIAL_KEY_SUB_TYPE = "subtype"
        const val CREDENTIAL_KEY_D_TYPE = "dType"
        const val CREDENTIAL_KEY_D_LENGTH = "dLength"
        const val CREDENTIAL_KEY_CRED_ALLOWED = "CredAllowed"
        const val CREDENTIAL_PREF_LANGUAGE = "en_US"

        const val OTP_CREDENTIAL_TYPE = "OTP"
        const val OTP_CREDENTIAL_SUB_TYPE = "SMS"
        const val ATM_CREDENTIAL_TYPE = "PIN"
        const val CARD_CREDENTIAL_SUB_TYPE = "ATMPIN"
        const val AADHAAR_CREDENTIAL_TYPE = "AADHAAR"
        const val ATM_CREDENTIAL_SUB_TYPE = "MPIN"
        const val NEW_PIN_CREDENTIAL_SUB_TYPE = "NMPIN"

        const val CRED_TYPE_BALANCE_ENQUIRY = "reqBalEnq"
        const val CRED_TYPE_PAY = "pay"
        const val CRED_TYPE_SET_PIN = "setMpin"
        const val CRED_TYPE_CHANGE_PIN = "changeMpin"

        const val VPA_REQUEST_TYPE_REGISTRATION = "R"
        const val VPA_REQUEST_TYPE_TRANSACTION = "T"

        const val SET_PIN_TYPE_DEBIT = "DEBIT"
        const val SET_PIN_TRANSACTION_NOTE = "setUPIPin"

        const val DEVICE_ID_KEY = "sp_deviceId"
        const val APP_GEN_ID_KEY = "sp_appGenId"
        const val REGISTERED_MOBILE = "sp_registered_mobile"

        const val PAYU_DD_MM_YYYY = "dd/MM/yyyy"
        const val PAYU_YYYY_MM_DD = "yyyy-MM-dd"

        const val REMOVE_ACCOUNT_REQUEST_TYPE = "RA"

        const val PARAM_BANK_CODE = "Bank code"
        const val PARAM_START_DATE = "Start date"
        const val PARAM_END_DATE = "End date"
        const val PARAM_REQUEST_TYPE = "Request type"
        const val PARAM_VPA = "VPA"
        const val PARAM_CARD_NO = "Card number"
        const val PARAM_EXPIRY = "Expiry date"
        const val PARAM_TXN_ID = "Txn id"
        const val PARAM_REF_ID = "Ref id"
        const val PARAM_QUERY = "Query"
        const val PARAM_QUERY_TYPE = "Query type"
        const val PARAM_AMOUNT = "Amount"
        const val PARAM_PAYEE_NAME = "Payee name"
        const val PARAM_PAYEE_VPA = "Payee vpa"
        const val PARAM_INIT_MODE = "Init mode"
        const val PARAM_PURPOSE = "Purpose"
        const val PARAM_TXN_REF_NO = "Txn ref number"
        const val TXN_HISTORY_INPUT_DATE_FORMAT = "yyyy-MM-dd hh:mm:ss"
        const val TXN_HISTORY_OUTPUT_DATE_FORMAT = "dd/MM/yyyy hh:mm:ss aa"
        const val HDFC_HANDLE = "@hdfc"

        // device info constants
        const val DEVICE_INFO_CAPABILITY = "5200000200010004000639292929292"
        const val DEVICE_INFO_RELAY_BUTTON = "VgyT0ixZCMFRIR9sJSoACfHKImt0uEHEcWfbcgo8i4Y="
        const val DEVICE_INFO_LOCATION = "Bangalore"
        const val DEVICE_INFO_IP = "127.0.0.1"
        const val DEVICE_INFO_LAT_LNG = "0.0 ,0.0"
        const val BHIM_PACKAGE_NAME = "in.org.npci.upi.sdk.payu"
        const val DEVICE_INFO_OS = "ANDROID"

        // error codes
        const val MOBILE_MISMATCH_CODE = "MM"
        const val DEVICE_FINGERPRINT_MISMATCH_CODE = "U66"
        const val DEVICE_REGISTRATION_FAILED = "U63"

        // CL error codes
        const val TECHNICAL_ISSUE = "L05"
        const val KEY_CODE_NOT_PROVIDED = "L06"
        const val ERROR_PARSING_KEY_CODE = "L07"
        const val XML_PAYLOAD_NOT_PROVIDED = "L08"
        const val ERROR_PARSING_XML_PAYLOAD = "L09"
        const val ERROR_PARSING_CONTROLS = "L10"
        const val ERROR_PARSING_CONFIGURATION = "L11"
        const val SALT_NOT_PROVIDED = "L12"
        const val ERROR_PARSING_SALT = "L13"
        const val ERROR_PARSING_PAY_INFO = "L14"
        const val ERROR_PARSING_LOCALE = "L15"
        const val UNKNOWN_ERROR_OCCURRED = "L16"
        const val TRUST_NOT_PROVIDED = "L17"
        const val SALT_VALUES_NOT_PROVIDED = "L18"
        const val ERROR_PARSING_SALT_VALUES = "L19"
        const val TRUST_IS_NOT_VALID = "L20"
    }

    val CLErrorCodes = listOf(TECHNICAL_ISSUE, KEY_CODE_NOT_PROVIDED, ERROR_PARSING_KEY_CODE,
        XML_PAYLOAD_NOT_PROVIDED, ERROR_PARSING_XML_PAYLOAD, ERROR_PARSING_CONTROLS,
        ERROR_PARSING_CONFIGURATION, SALT_NOT_PROVIDED, ERROR_PARSING_SALT, ERROR_PARSING_PAY_INFO,
        ERROR_PARSING_LOCALE, UNKNOWN_ERROR_OCCURRED, TRUST_NOT_PROVIDED, SALT_VALUES_NOT_PROVIDED,
        ERROR_PARSING_SALT_VALUES, TRUST_IS_NOT_VALID)
}