package com.payu.upiboltcore.interfaces

import com.payu.commonmodelssdk.listeners.PayUUPIBoltCallBack
import com.payu.upiboltcore.models.AccountInfo

interface ManagementService {

    fun setMpin(account: AccountInfo, cardNo: String, exp: String, payUUpiProCallBack: PayUUPIBoltCallBack)
    fun changeMpin(account: AccountInfo, callback: PayUUPIBoltCallBack)
    fun checkBalance(account: AccountInfo, callback: PayUUPIBoltCallBack)
    fun raiseDispute(
        txnId: String, refId: String?, query: String, queryType: String?,
        payUUpiProCallBack: PayUUPIBoltCallBack
    )
    fun addAccount(accountInfo: AccountInfo, payUUpiProCallBack: PayUUPIBoltCallBack)
    fun getDisputeList(payUUpiProCallBack: PayUUPIBoltCallBack)
    fun removeAccount(account: AccountInfo, payUUpiProCallBack: PayUUPIBoltCallBack)
    fun deregisterVpa(payUUpiProCallBack: PayUUPIBoltCallBack)
    fun getTransactionHistoryList(
        startDate: String, endDate: String, payUUpiProCallBack: PayUUPIBoltCallBack
    )
    fun getDisputeTypeList(upiTxnRefNo: String, payUUpiProCallBack: PayUUPIBoltCallBack)
    fun checkDisputeStatus(txnId: String, payUUpiProCallBack: PayUUPIBoltCallBack)
}