package com.payu.upiboltcore.interfaces

import com.payu.commonmodelssdk.listeners.OTPVerificationInterface
import com.payu.commonmodelssdk.listeners.PayUUPIBoltCallBack
import com.payu.upiboltcore.models.AccountInfo

interface RegistrationService {

    fun checkDeviceStatus(
        isOtpVerified: Boolean = false,
        otpVerificationInterface: OTPVerificationInterface?,
        payUUPIProCallBack: PayUUPIBoltCallBack
    )

    fun registerApp(
        otpVerificationInterface: OTPVerificationInterface,
        payUUPIProCallBack: PayUUPIBoltCallBack
    )

    fun getBankList(payuApiCallBack: PayUUPIBoltCallBack)
    fun getAccountsList(
        bankCode: String?,
        requestType: String?,
        iin: String?,
        bankId: String?,
        accountType: String?,
        payuApiCallBack: PayUUPIBoltCallBack
    )

    fun registerVPA(
        vpa: String, accountInfo: AccountInfo, payUUpiProCallBack: PayUUPIBoltCallBack
    )

    fun validateOtp(
        otp: String,
        otpVerificationInterface: OTPVerificationInterface?,
        payUUpiProCallBack: PayUUPIBoltCallBack
    )
}