package com.payu.upiboltcore.models

import org.json.JSONObject

data class AddAccountRequest(
    val deviceInfo: DeviceInfo,
    val userInfo: UserInfo,
    val referenceId: String?=null
) {
    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val USER_INFO = "userInfo"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(USER_INFO, userInfo.getJSONObject())
            put(REFERENCE_ID, referenceId)
        }
    }
}