package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class AddAccountResponse(
    val guid: String,
    val message: String,
    val result: AddAccountResponseResult,
    val status: Int
) {
    companion object {
        fun getAddAccountResponseFromJSON(string: String): AddAccountResponse {
            val json = JSONObject(string)
            val result = AddAccountResponseResult.getAddAccountResponseFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return AddAccountResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class AddAccountResponseResult(
    val response: String
) {
    companion object {
        const val RESPONSE = "response"

        fun getAddAccountResponseFromJSON(jsonObject: JSONObject): AddAccountResponseResult {
            return AddAccountResponseResult(jsonObject.optString(RESPONSE))
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(RESPONSE, response)
        }
    }
}