package com.payu.upiboltcore.models

import org.json.JSONObject

data class ChangeMPinRequest(
    val accountId: String,
    val mpinCredentials: Credential,
    val newMpinCredentials: Credential,
    val npciTransactionId: String,
    val deviceInfo: DeviceInfo,
    val payerType: PayerType,
    val virtualAddress: String,
    val referenceId: String?=null
) {
    companion object {
        const val ACCOUNT_ID = "accountId"
        const val MPIN_CREDNETIALS = "mpinCredentials"
        const val NEW_MPIN_CREDENTIALS = "newMpinCredentials"
        const val NPCI_TRANSACTION_ID = "npciTransactionId"
        const val DEVICE_INFO = "deviceInfo"
        const val PAYER_TYPE = "payerType"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(ACCOUNT_ID, accountId)
            put(MPIN_CREDNETIALS, mpinCredentials.getJSONObject())
            put(NEW_MPIN_CREDENTIALS, newMpinCredentials.getJSONObject())
            put(NPCI_TRANSACTION_ID, npciTransactionId)
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(PAYER_TYPE, payerType.getJSONObject())
            put(VIRTUAL_ADDRESS, virtualAddress)
            put(REFERENCE_ID, referenceId)
        }
    }
}

