package com.payu.upiboltcore.models

import org.json.JSONArray
import org.json.JSONObject

data class CheckDeviceStatusRequest(
    val checkRootDetection: Boolean = false,
    val issuingBanks: List<String>,
    val clientId : String,
    val deviceInfo: DeviceInfo,
    val referenceId: String? = null,
    val smsGateWayNo: String? = null,
    val registeredMobile: String? = null,
    val isSmsSent: Boolean = false,
    val isOtpVerified: Boolean = false
) {
    companion object {
        const val CHECK_ROOT_DETECTION = "checkRootDetection"
        const val ISSUING_BANKS = "issuingBanks"
        const val CLIENT_ID = "clientId"
        const val DEVICE_INFO = "deviceInfo"
        const val REFERENCE_ID = "referenceId"
        const val SMS_GATEWAY_NO = "smsGateWayNo"
        const val REGISTERED_MOBILE = "registeredMobile"
        const val IS_SMS_SENT = "isSmsSent"
        const val IS_OTP_VERIFIED = "isOtpVerified"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(CHECK_ROOT_DETECTION, checkRootDetection)
            put(ISSUING_BANKS, JSONArray().apply {
                for (i in issuingBanks.indices) {
                    put(i, issuingBanks[i])
                }
            })
            put(CLIENT_ID, clientId)
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(REFERENCE_ID, referenceId)
            if (smsGateWayNo.isNullOrEmpty().not())
                put(SMS_GATEWAY_NO, smsGateWayNo)
            if(registeredMobile.isNullOrEmpty().not())
                put(REGISTERED_MOBILE, registeredMobile)
            put(IS_SMS_SENT, isSmsSent)
            put(IS_OTP_VERIFIED, isOtpVerified)
        }
    }
}