package com.payu.upiboltcore.models

import org.json.JSONObject

data class CheckTransactionStatusRequest(
    val deviceInfo: DeviceInfo,
    val actionType: String,
    val onBehalfOf: String,
    val orgPspRefNo: String?=null,
    val txnDate: String?=null,
    val txnId: String,
    val referenceId: String?=null
) {
    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val ACTION_TYPE = "actionType"
        const val ON_BEHALF_OF = "onBehalfOf"
        const val ORG_PSP_REF_NO = "orgPspRefNo"
        const val TXN_DATE = "txnDate"
        const val TXN_ID = "txnId"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(ACTION_TYPE, actionType)
            put(ON_BEHALF_OF, onBehalfOf)
            put(ORG_PSP_REF_NO, orgPspRefNo)
            put(TXN_DATE, txnDate)
            put(TXN_ID, txnId)
            put(REFERENCE_ID, referenceId)
        }
    }
}