package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class CheckTransactionStatusResponse(
    val guid: String,
    val message: String,
    val result: CheckTransactionStatusResponseResult,
    val status: Int
) {
    companion object {
        fun getTransactionStatusResponseFromJSON(string: String): CheckTransactionStatusResponse {
            val json = JSONObject(string)
            val result = CheckTransactionStatusResponseResult.getTransactionStatusResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return CheckTransactionStatusResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class CheckTransactionStatusResponseResult(
    val amount: String,
    val npciTxnId: String,
    val status: String,
    val statusDesc: String,
    val txnRefNo: Int,
    val txnStatusDetails: TxnStatusDetails,
    val upiTxnRefNo: Int
) {
    companion object {
        const val AMOUNT = "amount"
        const val NPCI_TXN_ID = "npciTxnId"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val TXN_REF_NO = "txnRefNo"
        const val TXN_STATUS_DETAILS = "txnStatusDetails"
        const val UPI_TXN_REF_NO = "upiTxnRefNo"

        fun getTransactionStatusResponseResultFromJSON(jsonObject: JSONObject): CheckTransactionStatusResponseResult {
            val txnDetails = TxnStatusDetails.getTxnStatusDetailsFromJSON(jsonObject.getJSONObject(
                TXN_STATUS_DETAILS))
            return CheckTransactionStatusResponseResult(
                jsonObject.optString(AMOUNT), jsonObject.optString(NPCI_TXN_ID),
                jsonObject.optString(STATUS), jsonObject.optString(STATUS_DESC),
                jsonObject.optInt(TXN_REF_NO), txnDetails,
                jsonObject.optInt(UPI_TXN_REF_NO)
            )
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(AMOUNT, amount)
            put(NPCI_TXN_ID ,npciTxnId)
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
            put(TXN_REF_NO, txnRefNo)
            put(TXN_STATUS_DETAILS, txnStatusDetails.getJSONObject())
            put(UPI_TXN_REF_NO, upiTxnRefNo)
        }
    }
}

data class TxnStatusDetails(
    val respCode: String,
    val result: String,
    val txnId: String
) {
    companion object {
        const val RESP_CODE = "respCode"
        const val RESULT = "result"
        const val TXN_ID = "txnId"

        fun getTxnStatusDetailsFromJSON(jsonObject: JSONObject): TxnStatusDetails {
            return TxnStatusDetails(jsonObject.optString(RESP_CODE), jsonObject.optString(RESULT), jsonObject.optString(TXN_ID))
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(RESP_CODE, respCode)
            put(RESULT, result)
            put(TXN_ID, txnId)
        }
    }
}