package com.payu.upiboltcore.models

import org.json.JSONObject

data class ComplaintInfo(
    val actionType: String = "BACKOFFICE",
    val disputeType: String?,
    val onBehalfOf: String = "TXNDISPUTE",
    val orgRrn: String? = null,
    val orgTxnDate: String? = null,
    val orgTxnId: String? = null,
    val rrn: String? = null,
    val txnId: String? = null,
    val userMsg: String? = null,
    val crn: String? = null,
    val expectedResolDate: String? = null,
    val ticketNo: String? = null,
) {
    companion object {
        const val ACTION_TYPE = "actionType"
        const val DISPUTE_TYPE = "disputeType"
        const val ON_BEHALF_OF = "onBehalfOf"
        const val ORG_RRN = "orgRrn"
        const val ORG_TXN_DATE = "orgTxnDate"
        const val ORG_TXN_ID = "orgTxnId"
        const val RRN = "rrn"
        const val TXN_ID = "txnId"
        const val USER_MSG = "userMsg"
        const val CRN = "crn"
        const val EXPECTED_RESOL_DATE = "expectedResolDate"
        const val TICKET_NO = "ticketNo"

        fun getComplainInfoFromJSON(jsonObject: JSONObject): ComplaintInfo {
            return ComplaintInfo(actionType = jsonObject.optString(ACTION_TYPE),
                disputeType = jsonObject.optString(DISPUTE_TYPE), crn = jsonObject.optString(
                CRN), expectedResolDate = jsonObject.optString(EXPECTED_RESOL_DATE),
                ticketNo = jsonObject.optString(TICKET_NO), txnId = jsonObject.optString(TXN_ID))
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(ACTION_TYPE, actionType)
            put(DISPUTE_TYPE, disputeType)
            put(ON_BEHALF_OF, onBehalfOf)
            put(ORG_RRN, orgRrn)
            put(ORG_TXN_DATE, orgTxnDate)
            put(ORG_TXN_ID, orgTxnId)
            put(RRN, rrn)
            put(TXN_ID, txnId)
            put(USER_MSG, userMsg)
            put(CRN, crn)
            put(EXPECTED_RESOL_DATE, expectedResolDate)
            put(TICKET_NO, ticketNo)
        }
    }
}