package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class DeRegisterVPAResponse(
    val guid: String,
    val message: String,
    val result: DeRegisterVPAResponseResult,
    val status: Int
) {
    companion object {
        fun getDeRegisterVPAResponseFromJSON(string: String): DeRegisterVPAResponse {
            val json = JSONObject(string)
            val result = DeRegisterVPAResponseResult.getDeRegisterVPAResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return DeRegisterVPAResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class DeRegisterVPAResponseResult(
    val statusDesc: String,
    val deregistrationDate: String
) {
    companion object {
        const val STATUS_DESC = "statusDesc"
        const val DE_REGISTRATION_DATE = "deregistrationDate"

        fun getDeRegisterVPAResponseResultFromJSON(jsonObject: JSONObject): DeRegisterVPAResponseResult {
            return DeRegisterVPAResponseResult(
                jsonObject.optString(STATUS_DESC), jsonObject.optString(DE_REGISTRATION_DATE)
            )
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(STATUS_DESC, statusDesc)
            put(DE_REGISTRATION_DATE, deregistrationDate)
        }
    }
}
