package com.payu.upiboltcore.models

import com.payu.upiboltcore.utils.Utils
import org.json.JSONObject

data class DeviceInfo(
    val androidId: String,
    val appGenId: String,
    val appName: String,
    val appVersionCode: String,
    val capability: String,
    val deviceId: String,
    val deviceType: String,
    val geoCode: String,
    val ip: String? = null,
    var location: String,
    var mobileNo: String,
    val os: String,
    val relayButton: String? = null,
    val selectedSimSlot: String? = null,
    val simId: String? = null,
    val manufacturer: String? = null,
    val model: String? = null,
    val osVersion: String? = null
) {

    companion object {

        const val ANDROID_ID = "androidId"
        const val APP_GEN_ID = "appGenId"
        const val APP_NAME = "appName"
        const val APP_VERSION_CODE = "appVersionCode"
        const val CAPABILITY = "capability"
        const val DEVICE_ID = "deviceId"
        const val DEVICE_TYPE = "deviceType"
        const val GEO_CODE = "geoCode"
        const val IP = "ip"
        const val LOCATION = "location"
        const val MOBILE_NO = "mobileNo"
        const val OS = "os"
        const val RELAY_BUTTON = "relayButton"
        const val SELECTED_SIM_SLOT = "selectedSimSlot"
        const val SIM_ID = "simId"
        const val MANUFACTURER = "manufacturer"
        const val MODEL = "model"
        const val OS_VERSION = "osVersion"

        fun getDeviceInfoFromJSON(json: JSONObject): DeviceInfo {
            return DeviceInfo(
                androidId = json.optString(ANDROID_ID), appGenId = json.optString(APP_GEN_ID),
                appName = json.optString(APP_NAME), appVersionCode = json.optString(APP_VERSION_CODE),
                capability = json.optString(CAPABILITY), deviceId = json.optString(DEVICE_ID),
                deviceType = json.optString(DEVICE_TYPE), geoCode = json.optString(GEO_CODE),
                ip = json.optString(IP), location = json.optString(LOCATION),
                mobileNo = json.optString(MOBILE_NO), os = json.optString(OS),
                relayButton = json.optString(RELAY_BUTTON),
                selectedSimSlot = json.optString(SELECTED_SIM_SLOT), simId = json.optString(SIM_ID),
                manufacturer = json.optString(MANUFACTURER), model = json.optString(MODEL),
                osVersion = json.optString(OS_VERSION)
            )
        }
    }

    fun getJSONObject(maskPi: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(ANDROID_ID, androidId)
            put(APP_GEN_ID, appGenId)
            put(APP_NAME, appName)
            put(APP_VERSION_CODE, appVersionCode)
            put(CAPABILITY, capability)
            put(DEVICE_ID, deviceId)
            put(DEVICE_TYPE, deviceType)
            put(GEO_CODE, geoCode)
            put(IP, ip)
            put(LOCATION, location)
            put(
                MOBILE_NO,
                if (maskPi)
                    Utils.getMaskedString(mobileNo)
                else
                    mobileNo
            )
            put(OS, os)
            put(RELAY_BUTTON, relayButton)
            put(SIM_ID, simId)
            put(MANUFACTURER, manufacturer)
            put(MODEL, model)
            put(OS_VERSION, osVersion)
        }
    }
}