package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class GenerateOTPResponse(
    val guid: String,
    val message: String,
    val result: GenerateOTPResponseResult,
    val status: Int
) {
    companion object {
        fun getGenerateOTPResponseFromJSON(string: String): GenerateOTPResponse {
            val json = JSONObject(string)
            val result = GenerateOTPResponseResult.getGenerateOTPResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return GenerateOTPResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class GenerateOTPResponseResult(
    val otpSent: Boolean? = null,
    val otpExpiresIn: Int? = null,
    val otpAttemptsRem: Int? = null,
    val senderId: List<String>? = null
) {

    companion object {
        const val OTP_SENT = "otpSent"
        const val OTP_EXPIRES_IN = "otpExpiresIn"
        const val OTP_ATTEMPTS_REM = "otpAttemptsRem"
        const val SENDER_ID = "senderId"

        fun getGenerateOTPResponseResultFromJSON(jsonObject: JSONObject): GenerateOTPResponseResult {
            val senderIdArray = jsonObject.optJSONArray(SENDER_ID)
            senderIdArray?.let {
                List(it.length()) { index ->
                    senderIdArray.getString(index)
                }
            }
            return GenerateOTPResponseResult(
                jsonObject.optBoolean(OTP_SENT), jsonObject.optInt(OTP_EXPIRES_IN),
                jsonObject.optInt(OTP_ATTEMPTS_REM),
            )
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(OTP_SENT, otpSent)
            put(OTP_EXPIRES_IN, otpExpiresIn)
            put(OTP_ATTEMPTS_REM, otpAttemptsRem)
            put(SENDER_ID, senderId)
        }
    }
}