package com.payu.upiboltcore.models

import org.json.JSONObject

data class GetBankListRequest(
    val deviceInfo: DeviceInfo,
    val appVersionCode: Int = 0,
    val checkMultiVpa: Boolean = false,
    val check_root_detection: Boolean = false,
    val isMerchant: Boolean = false,
    val isPreRegUser: Boolean = false,
    val merchCustFlag: Boolean = false,
    val preRegistrationStatus: Boolean = false,
    val recoveryOptionFlag: Int = 0,
    val sendRegSms: Boolean = false,
    val smsSent: Boolean= false,
    val updateFlag: Int = 0,
    val referenceId: String?=null
) {
    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val APP_VERSION_CODE = "appVersionCode"
        const val CHECK_MULTI_VPA = "checkMultiVpa"
        const val CHECK_ROOT_DETECTION = "check_root_detection"
        const val IS_MERCHANT = "isMerchant"
        const val IS_PRE_REG_USER = "isPreRegUser"
        const val MERCH_CUST_FLAG = "merchCustFlag"
        const val PRE_REGISTRATION_STATUS = "preRegistrationStatus"
        const val RECOVERY_OPTION_FLAG = "recoveryOptionFlag"
        const val SEND_REG_SMS = "sendRegSms"
        const val SMS_SENT = "smsSent"
        const val UPDATE_FLAG = "updateFlag"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(APP_VERSION_CODE, appVersionCode)
            put(CHECK_MULTI_VPA, checkMultiVpa)
            put(CHECK_ROOT_DETECTION, check_root_detection)
            put(IS_MERCHANT, isMerchant)
            put(IS_PRE_REG_USER, isPreRegUser)
            put(MERCH_CUST_FLAG, merchCustFlag)
            put(PRE_REGISTRATION_STATUS, preRegistrationStatus)
            put(RECOVERY_OPTION_FLAG, recoveryOptionFlag)
            put(SEND_REG_SMS, sendRegSms)
            put(SMS_SENT, smsSent)
            put(UPDATE_FLAG, updateFlag)
            put(REFERENCE_ID, referenceId)
        }
    }
}