package com.payu.upiboltcore.models

import org.json.JSONObject

data class InitiateMPinRequest(
    val accountId: String?=null,
    val accountInfo: AccountInfo,
    val deviceInfo: DeviceInfo,
    val expiryDate: String?=null,
    val lastSixDigitDebitCardNo: String?=null,
    val payerType: PayerType,
    val setPinType: String?=null,
    val transactionNote: String?=null,
    val virtualAddress: String,
    val cardType: String? = null,
    val npciTransactionId: String? = null,
    val refId: String? = null,
    val refUrl: String? = null,
    val otpSubType: String = "BANK-UIDAI",
    val referenceId: String?=null
) {
    companion object {
        const val ACCOUNT_ID = "accountId"
        const val ACCOUNT_INFO = "accountInfo"
        const val DEVICE_INFO = "deviceInfo"
        const val EXPIRY_DATE = "expiryDate"
        const val LAST_SIX_DIGIT_DEBIT_CARD_NO = "lastSixDigitDebitCardNo"
        const val PAYER_TYPE = "payerType"
        const val SET_PIN_TYPE = "setPinType"
        const val TRANSACTION_NOTE = "transactionNote"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val CARD_TYPE = "cardType"
        const val NPCI_TRANSACTION_ID = "npciTransactionId"
        const val REF_ID = "refId"
        const val REF_URL = "refUrl"
        const val OTP_SUB_TYPE = "otpSubType"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(ACCOUNT_ID, accountId)
            put(ACCOUNT_INFO, accountInfo.getJSONObject())
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(EXPIRY_DATE, expiryDate)
            put(LAST_SIX_DIGIT_DEBIT_CARD_NO, lastSixDigitDebitCardNo)
            put(PAYER_TYPE, payerType.getJSONObject())
            put(SET_PIN_TYPE, setPinType)
            put(TRANSACTION_NOTE, transactionNote)
            put(VIRTUAL_ADDRESS, virtualAddress)
            put(CARD_TYPE, cardType)
            put(NPCI_TRANSACTION_ID, npciTransactionId)
            put(REF_ID, refId)
            put(REF_URL, refUrl)
            put(OTP_SUB_TYPE, otpSubType)
            put(REFERENCE_ID, referenceId)
        }
    }
}