package com.payu.upiboltcore.models

import org.json.JSONArray
import org.json.JSONObject

data class PayInfo(
    val payeeName: String? = null,
    val accountNo: String? = null,
    val mobileNo: String? = null,
    val txnAmount: String = "0.00",
    val note: String? = null,
    var refId: String? = null,
    var refUrl: String? = null
) {
    fun getPayInfoJSON(): String {
        return JSONArray().apply {
            payeeName?.let {
                put(JSONObject().apply {
                    put("name", "payeeName")
                    put("value", payeeName)
                })
            }
            accountNo?.let {
                put(JSONObject().apply {
                    put("name", "account")
                    put("value", accountNo)
                })
            }
            mobileNo?.let {
                put(JSONObject().apply {
                    put("name", "mobileNumber")
                    put("value", mobileNo)
                })
            }
            put(JSONObject().apply {
                put("name", "txnAmount")
                put("value", txnAmount)
            })
            note?.let {
                put(JSONObject().apply {
                    put("name", "note")
                    put("value", note)
                })
            }
            refId?.let {
                put(JSONObject().apply {
                    put("name", "refId")
                    put("value", refId)
                })
            }
            refUrl?.let {
                put(JSONObject().apply {
                    put("name", "refUrl")
                    put("value", refUrl)
                })
            }
        }.toString()
    }
}
