package com.payu.upiboltcore.models

import com.payu.upiboltcore.utils.Utils
import org.json.JSONObject

data class PayerType(
    val accountId: String,
    val accountNo: String,
    val payerBankName: String,
    val virtualAddress: String,
    val name: String? = null,
    val isMerchant: Boolean? = null,
    val showMerchant: Boolean? = null,
    val defVPAStatus: Boolean? = null,
    val accountType: String? = null,
    val payerBankCode: String? = null
) {

    companion object {
        const val ACCOUNT_ID = "accountId"
        const val ACCOUNT_NO = "accNo"
        const val PAYER_BANK_NAME = "payerBankName"
        const val VIRTUAL_ADDRESS = "virtualAddress"
        const val NAME = "name"
        const val IS_MERCHANT = "isMerchant"
        const val SHOW_MERCHANT = "showMerchant"
        const val DEF_VPA_STATUS = "defVPAStatus"
        const val ACCOUNT_TYPE = "accountType"
        const val PAYER_BANK_CODE = "payerBankCode"

        fun getPayerTypeFromJSON(jsonObject: JSONObject): PayerType {
            return PayerType(
                jsonObject.optString(ACCOUNT_ID),
                jsonObject.optString(ACCOUNT_NO),
                jsonObject.optString(PAYER_BANK_NAME),
                jsonObject.optString(VIRTUAL_ADDRESS),
                jsonObject.optString(NAME),
                jsonObject.optBoolean(IS_MERCHANT),
                jsonObject.optBoolean(SHOW_MERCHANT),
                jsonObject.optBoolean(DEF_VPA_STATUS),
                jsonObject.optString(ACCOUNT_TYPE),
                jsonObject.optString(PAYER_BANK_CODE)
            )
        }
    }

    fun getJSONObject(maskPi: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(
                ACCOUNT_ID,
                if (maskPi)
                    Utils.getMaskedString(accountId)
                else
                    accountId
            )
            put(ACCOUNT_NO, accountNo)
            put(PAYER_BANK_NAME, payerBankName)
            put(
                VIRTUAL_ADDRESS,
                if (maskPi)
                    Utils.getMaskedString(virtualAddress)
                else
                    virtualAddress
            )
            put(NAME, name)
            put(IS_MERCHANT, isMerchant)
            put(SHOW_MERCHANT, showMerchant)
            put(DEF_VPA_STATUS, defVPAStatus)
            put(ACCOUNT_TYPE, accountType)
            put(PAYER_BANK_CODE, payerBankCode)
        }
    }
}