package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import org.json.JSONObject

data class RegisterVPAResponse(
    val guid: String,
    val message: String,
    val result: RegisterVPAResponseResult,
    val status: Int
) {
    companion object {
        fun getRegisterVPAResponseFromJSON(string: String): RegisterVPAResponse {
            val json = JSONObject(string)
            val result = RegisterVPAResponseResult.getRegisterVPAResponseResultFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return RegisterVPAResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class RegisterVPAResponseResult(
    val registrationDate: String,
    val servGenId: String?,
    val statusDesc: String,
    val userInfo: UserInfo
) {
    companion object {
        const val REGISTRATION_DATE = "registrationDate"
        const val SERVER_GEN_ID = "servGenId"
        const val STATUS_DESC = "statusDesc"
        const val USER_INFO = "userInfo"

        fun getRegisterVPAResponseResultFromJSON(jsonObject: JSONObject): RegisterVPAResponseResult {
            val userInfo = UserInfo.getUserInfoFromJSON(jsonObject.getJSONObject(USER_INFO))
            return RegisterVPAResponseResult(jsonObject.optString(REGISTRATION_DATE),
                jsonObject.optString(SERVER_GEN_ID), jsonObject.optString(STATUS_DESC),
                userInfo)
        }
    }

    fun getJSONObject(maskPi: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(REGISTRATION_DATE, registrationDate)
            put(SERVER_GEN_ID, servGenId)
            put(STATUS_DESC, statusDesc)
            put(USER_INFO, userInfo.getJSONObject(maskPi))
        }
    }
}