package com.payu.upiboltcore.models

import org.json.JSONArray
import org.json.JSONObject

data class RemoveAccountRequest(
    val deviceInfo: DeviceInfo,
    val userInfo: UserInfo,
    val requestType: String,
    val accountList: List<AccountInfo>,
    val referenceId: String?=null
) {
    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val USER_INFO = "userInfo"
        const val REQUEST_TYPE = "requestType"
        const val ACCOUNT_LIST = "accountList"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(USER_INFO, userInfo.getJSONObject())
            put(REQUEST_TYPE, requestType)
            put(ACCOUNT_LIST, AccountList.getJSONArray(accountList))
            put(REFERENCE_ID, referenceId)
        }
    }
}
data class AccountList(
    val accId: String
) {
    companion object {
        const val ACC_ID = "accId"

        fun getJSONArray(accountList: List<AccountInfo>): JSONArray {
            return JSONArray().apply {
                for (i in accountList.indices) {
                    put(i, JSONObject().apply {
                        put(ACC_ID, accountList[i].accountId)})
                }
            }
        }

    }
}
