package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import com.payu.upiboltcore.utils.Utils
import org.json.JSONObject

data class RemoveAccountResponse(
    val guid: String,
    val message: String,
    val result: RemoveAccountResponseResult,
    val status: Int
) {
    companion object {
        fun getRemoveAccountResponseFromJSON(string: String): RemoveAccountResponse {
            val json = JSONObject(string)
            val result = RemoveAccountResponseResult.getAddAccountResponseFromJSON(
                json.getJSONObject(URLConstants.RES_PARAM_RESULT)
            )
            return RemoveAccountResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class RemoveAccountResponseResult(
    val status: String,
    val statusDesc: String?,
    val errCode: String?,
    val accountId: String?,
    val requestInfo: RequestInfo?,

) {
    companion object {
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val ERR_CODE = "errCode"
        const val ACCOUNT_ID = "accountId"
        const val REQUEST_INFO = "requestInfo"
        fun getAddAccountResponseFromJSON(jsonObject: JSONObject): RemoveAccountResponseResult {
            return RemoveAccountResponseResult(jsonObject.optString(STATUS)
            ,jsonObject.optString(STATUS_DESC)
                ,jsonObject.optString(ERR_CODE)
                ,jsonObject.optString(ACCOUNT_ID)
            ,jsonObject.optJSONObject(REQUEST_INFO)?.let {
                    RequestInfo.getRequestInfoFromJSON(it)
                }
            )
        }
    }

    fun getJSONObject(maskPi: Boolean = false, logInfo: Boolean = false): JSONObject {
        return JSONObject().apply {
            put(STATUS, status)
            put(STATUS_DESC, statusDesc)
            put(ERR_CODE, errCode)
            put(
                ACCOUNT_ID,
                if (maskPi)
                    Utils.getMaskedString(accountId)
                else
                    accountId
            )
            if (logInfo.not())
                put(REQUEST_INFO, requestInfo)
        }
    }
}
