package com.payu.upiboltcore.models

import org.json.JSONObject

data class RequestInfo(
    val pspId: String? = null,
    val pspRefNo: String? = null,
    val pspRespRefNo: String? = null,
    val checksumFlag: String?=null
) {

    companion object {
        const val PSP_ID = "pspId"
        const val PSP_REF_NUM = "pspRefNo"
        const val PSP_RESP_REF_NUM = "pspRespRefNo"
        const val CHECKSUM_FLAG = "checksumFlag"

        fun getRequestInfoFromJSON(jsonObject: JSONObject): RequestInfo {
            var pspRespRefNo :String?=null
            var checksumFlag :String?=null
            if(jsonObject.has(PSP_RESP_REF_NUM)){
                pspRespRefNo = jsonObject.optString(PSP_RESP_REF_NUM)
            }
            if(jsonObject.has(CHECKSUM_FLAG)){
                checksumFlag = jsonObject.optString(CHECKSUM_FLAG)
            }
            return RequestInfo(jsonObject.optString(PSP_ID)
                ,jsonObject.optString(PSP_REF_NUM)
                ,pspRespRefNo
                ,checksumFlag)
        }
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(PSP_ID, pspId)
            put(PSP_REF_NUM, pspRefNo)
        }
    }


}
