package com.payu.upiboltcore.models

import org.json.JSONObject

data class SetMPinRequest(
    val otpCredentials: Credential? = null,
    val deviceInfo: DeviceInfo,
    val accountId: String?=null,
    val expiryDate: String?=null,
    val formatType: String?=null,
    val lastSixDigitDebitCardNo: String?=null,
    val mpinCredentials: Credential?=null,
    val atmPinCredentials: Credential? = null,
    val npciTranId: String?=null,
    val otpNpciTranId: String?=null,
    val referenceId: String?=null
) {
    companion object {
        const val OTP_CREDENTIALS = "otpCredentials"
        const val DEVICE_INFO = "deviceInfo"
        const val ACCOUNT_ID = "accountId"
        const val EXPIRY_DATE = "expiryDate"
        const val FORMAT_TYPE = "formatType"
        const val LAST_SIX_DIGIT_DEBIT_CARD_NO = "lastSixDigitDebitCardNo"
        const val MPIN_CREDENTIALS = "mpinCredentials"
        const val NPCI_TRAN_ID = "npciTranId"
        const val OTP_NPCI_TRAN_ID = "otpNpciTranId"
        const val ATM_PIN_CREDENTIALS = "atmCred"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(OTP_CREDENTIALS, otpCredentials?.getJSONObject())
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(ACCOUNT_ID, accountId)
            put(EXPIRY_DATE, expiryDate)
            put(FORMAT_TYPE, formatType)
            put(LAST_SIX_DIGIT_DEBIT_CARD_NO, lastSixDigitDebitCardNo)
            put(MPIN_CREDENTIALS, mpinCredentials?.getJSONObject())
            put(NPCI_TRAN_ID, npciTranId)
            put(OTP_NPCI_TRAN_ID, otpNpciTranId)
            put(ATM_PIN_CREDENTIALS, atmPinCredentials?.getJSONObject())
            put(REFERENCE_ID, referenceId)
        }
    }
}