package com.payu.upiboltcore.models

import com.payu.upiboltcore.constants.URLConstants
import com.payu.upiboltcore.utils.Utils
import org.json.JSONArray
import org.json.JSONObject

data class TransactionHistoryListResponse(
    val guid: String,
    val message: String,
    val result: List<TransactionHistoryListResponseResult>,
    val status: Int
) {
    companion object {
        fun getTransactionHistoryListResponseFromJSON(string: String): TransactionHistoryListResponse {
            val json = JSONObject(string)
            val result = TransactionHistoryListResponseResult.getTransactionHistoryListResponseResultFromJSON(
                json.getJSONArray(URLConstants.RES_PARAM_RESULT)
            )
            return TransactionHistoryListResponse(
                json.optString(URLConstants.RES_PARAM_GUID), json.optString(URLConstants.RES_PARAM_MESSAGE),
                result, json.optInt(URLConstants.RES_PARAM_STATUS)
            )
        }
    }
}

data class TransactionHistoryListResponseResult(
    val id: Int,
    val clientTxnId: String,
    val subClientIdentifier: String,
    val npciTxnId: String,
    val payerVpa: String,
    val payerAccountNumber: String,
    val payeeIfsc: String,
    val payerAccountType: String,
    val payeeVpa: String,
    val amount: String,
    val bankResponseCode: String,
    val apiResp: TransactionHistoryApiResponse?,
    val npciResponseCode: String,
    val addedOn: String,
    val updatedOn: String,
    val clientId: String,
    val customerId: String,
    val txnStatus: String,
    val mobileNumber: String,
    val payerBankName: String
) {
    companion object {
        private const val ID = "id"
        private const val CLIENT_TXN_ID = "clientTxnId"
        private const val SUB_CLIENT_IDENTIFIER = "subClientIdentifier"
        private const val NPCI_TXN_ID = "npciTxnId"
        private const val PAYER_VPA = "payerVpa"
        private const val PAYER_ACCOUNT_NUMBER = "payerAccountNumber"
        private const val PAYER_IFSC = "payeeIfsc"
        private const val PAYER_ACCOUNT_TYPE = "payerAccountType"
        private const val PAYEE_VPA = "payeeVpa"
        private const val AMOUNT = "amount"
        private const val BANK_RESPONSE_CODE = "bankResponseCode"
        private const val MESSAGE = "message"
        private const val NPCI_RESPONSE_CODE = "npciResponseCode"
        private const val ADDED_ON = "addedOn"
        private const val UPDATE_ON = "updatedOn"
        private const val CLIENT_ID = "clientId"
        private const val CUSTOMER_ID = "customerId"
        private const val TXN_STATUS = "txnStatus"
        private const val MOBILE_NUMBER = "mobileNumber"
        private const val PAYER_BANK_NAME = "payerBankName"


        fun getTransactionHistoryListResponseResultFromJSON(txnHistoryArray: JSONArray):  List<TransactionHistoryListResponseResult>{

           val txnHistoryList :  List<TransactionHistoryListResponseResult> = List(txnHistoryArray.length()) {
              getTxnHistoryInfoFromJSON(txnHistoryArray.getJSONObject(it))
            }
           return txnHistoryList
        }

        private fun getTxnHistoryInfoFromJSON(jsonObject: JSONObject): TransactionHistoryListResponseResult {
            val message = if((jsonObject.opt(MESSAGE) as? String?).isNullOrEmpty().not()) {
                TransactionHistoryApiResponse.getApiRespFromJSON(JSONObject(jsonObject.optString(MESSAGE)))
            } else null
            return TransactionHistoryListResponseResult(
                jsonObject.optInt(ID),
                jsonObject.optString(CLIENT_TXN_ID),
                jsonObject.optString(SUB_CLIENT_IDENTIFIER),
                jsonObject.optString(NPCI_TXN_ID),
                jsonObject.optString(PAYER_VPA),
                jsonObject.optString(PAYER_ACCOUNT_NUMBER),
                jsonObject.optString(PAYER_IFSC),
                jsonObject.optString(PAYER_ACCOUNT_TYPE),
                jsonObject.optString(PAYEE_VPA),
                jsonObject.optString(AMOUNT),
                jsonObject.optString(BANK_RESPONSE_CODE),
                message,
                jsonObject.optString(NPCI_RESPONSE_CODE),
                Utils.convertTxnHistoryDateFormat(jsonObject.optString(ADDED_ON)),
                Utils.convertTxnHistoryDateFormat(jsonObject.optString(UPDATE_ON)),
                jsonObject.optString(CLIENT_ID),
                jsonObject.optString(CUSTOMER_ID),
                jsonObject.optString(TXN_STATUS),
                jsonObject.optString(MOBILE_NUMBER),
                jsonObject.optString(PAYER_BANK_NAME)
            )
        }
    }
}

data class TransactionHistoryApiResponse(
    val custRefNo: String,
    val upiTransRefNo: Long,
    val amount: String,
    val txnAuthDate: String, //"03/10/2024 12:12:02"
    val status: String,
    val statusDesc: String,
    val payerVPA: String,
    val payeeVPA: String,
    val npciTransId: String,
    val errorCode: String,
    val payType: String,
    val refId: String,
    val mcc: String,
    val payeeName: String
) {

    companion object {

        const val API_RESP = "apiResp"
        const val CUST_REF_NO = "custRefNo"
        const val UPI_TRANS_REF_NO = "upiTransRefNo"
        const val AMOUNT = "amount"
        const val TXN_AUTH_DATE = "txnAuthDate"
        const val STATUS = "status"
        const val STATUS_DESC = "statusDesc"
        const val PAYER_VPA = "payerVPA"
        const val PAYEE_VPA = "payeeVPA"
        const val NPCI_TRANS_ID = "npciTransId"
        const val ERROR_CODE = "errorCode"
        const val PAY_TYPE = "payType"
        const val REF_ID = "refId"
        const val MCC = "mcc"
        const val PAYEE_NAME = "payeeName"

        fun getApiRespFromJSON(jsonObject: JSONObject): TransactionHistoryApiResponse? {
            return jsonObject.optJSONObject(API_RESP)?.let { apiResp ->
                TransactionHistoryApiResponse(apiResp.optString(CUST_REF_NO),
                    apiResp.optLong(UPI_TRANS_REF_NO), apiResp.optString(AMOUNT),
                    apiResp.optString(TXN_AUTH_DATE), apiResp.optString(STATUS),
                    apiResp.optString(STATUS_DESC), apiResp.optString(PAYER_VPA),
                    apiResp.optString(PAYEE_VPA), apiResp.optString(NPCI_TRANS_ID),
                    apiResp.optString(ERROR_CODE), apiResp.optString(PAY_TYPE),
                    apiResp.optString(REF_ID), apiResp.optString(MCC),
                    apiResp.optString(PAYEE_NAME)
                )
            }
        }
    }
}