package com.payu.upiboltcore.models

import org.json.JSONObject

data class TransactionHistoryRequest(
    val startDate: String,
    val endDate: String,
    val mobileNumber: String,
    val referenceId: String?=null
) {
    companion object {
        const val START_DATE = "startDate"
        const val END_DATE = "endDate"
        const val MOBILE_NUMBER = "mobileNumber"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(START_DATE, startDate)
            put(END_DATE, endDate)
            put(MOBILE_NUMBER, mobileNumber)
            put(REFERENCE_ID, referenceId)
        }
    }
}