package com.payu.upiboltcore.models;

import org.json.JSONObject

data class ValidateOTPRequest(
    val deviceInfo: DeviceInfo,
    val otp: String,
    val referenceId: String? = null
) {

    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val OTP = "otp"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(OTP, otp)
            put(REFERENCE_ID, referenceId)
        }
    }
}
