package com.payu.upiboltcore.models

import org.json.JSONObject

data class VerifyServerGenIDRequest(
    val deviceInfo: DeviceInfo,
    val userInfo: UserInfo?=null,
    val requestType: String,
    val rvh: String?=null,
    val referenceId: String?=null
) {
    companion object {
        const val DEVICE_INFO = "deviceInfo"
        const val USER_INFO = "userInfo"
        const val REQUEST_TYPE = "requestType"
        const val RVH = "rvh"
        const val REFERENCE_ID = "referenceId"
    }

    fun getJSONObject(): JSONObject {
        return JSONObject().apply {
            put(DEVICE_INFO, deviceInfo.getJSONObject())
            put(USER_INFO, userInfo?.getJSONObject())
            put(REQUEST_TYPE, requestType)
            put(RVH, rvh)
            put(REFERENCE_ID, referenceId)
        }
    }
}