package com.payu.upiboltcore.network

import android.os.Handler
import android.os.Looper
import com.payu.commonmodelssdk.constants.PayUResponseCodes
import com.payu.commonmodelssdk.constants.PayUResponseMessages
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.upiboltcore.constants.UPIConstants
import com.payu.upiboltcore.constants.payUErrorCodeMap
import com.payu.upiboltcore.models.BaseResponse
import okhttp3.Response

open class BaseRepository {

    protected fun sendSuccessCallback(callback: ApiBaseCallback, response: Any) {
        val handler = Handler(Looper.getMainLooper())
        val runnable = Runnable {
            callback.onApiSuccess(response)
        }
        handler.post(runnable)
    }

    protected fun sendFailureCallback(callback: ApiBaseCallback, errorCode: Int, errorMessage: String) {
        val handler = Handler(Looper.getMainLooper())
        val runnable = Runnable {
            callback.onApiError(errorCode, errorMessage)
        }
        handler.post(runnable)
    }

    protected fun getResponse(
        response: Any,
        apiCallback: ApiBaseCallback,
        getResponse: (response: String) -> Unit
    ) {
        (response as? Response)?.body?.string()?.let {
            val result = BaseResponse.getBaseResponseFromJSON(it).result
            val isFailure = result != null && (result.errorCode.isNullOrEmpty().not()
                    || (result.status.isNullOrEmpty().not()
                    && result.status == UPIConstants.RESPONSE_STATUS_FAILURE))
            if (isFailure.not()) {
                getResponse.invoke(it)
            } else {
                sendFailureCallback(
                    apiCallback, result?.errorCode?.let { code ->
                        payUErrorCodeMap[code] ?: PayUResponseCodes.PAYU_FAILED_STATUS
                    } ?: PayUResponseCodes.PAYU_FAILED_STATUS,
                    result?.statusDesc ?: PayUResponseMessages.RUNTIME_ERROR_MESSAGE
                )
            }
        } ?: kotlin.run {
            sendFailureCallback(
                apiCallback, PayUResponseCodes.PAYU_FAILED_STATUS,
                PayUResponseMessages.PAYU_INVALID_RESPONSE_MESSAGE
            )
        }
    }
}