package com.payu.upiboltcore.network

import android.util.Log
import com.payu.upiboltcore.InternalConfig
import com.payu.upiboltcore.constants.URLConstants
import kotlin.collections.HashMap

class CommonHeaders {

    fun getAuthTokenHeaders(): HashMap<String, String> {
        Log.d("Access Token","Bearer ${AuthTokenRepository.authToken}" )
        return HashMap<String, String>().apply {
            this[URLConstants.PARAM_AUTHORIZATION] = "Bearer ${AuthTokenRepository.authToken}"
            this[URLConstants.PARAM_USERNAME] = InternalConfig.sdkInitParams?.mKey?:""
            this[URLConstants.PARAM_DEVICE_INFO] = "${InternalConfig.sdkInitParams?.getPhone()}|${InternalConfig.sdkInitParams?.appId}"
            this[URLConstants.PARAM_BANK_ID] = InternalConfig.issuingBanks[0].lowercase()
        }
    }
}