package com.payu.upiboltcore.network

import com.payu.commonmodelssdk.constants.PayUResponseCodes.PAYU_FAILED_STATUS
import com.payu.commonmodelssdk.listeners.ApiBaseCallback
import com.payu.commonmodelssdk.listeners.PayUAsyncTaskResponse
import com.payu.upiboltcore.constants.UPIConstants
import com.payu.upiboltcore.models.ListKeysResponse
import com.payu.upiboltcore.models.UPITokenRequest
import com.payu.upiboltcore.models.UPITokenResponse

class NPCIRepository(
    private val commonHeaders: CommonHeaders,
    private val upiCoreApiService: UpiCoreApiService
) : BaseRepository() {

    fun getUPIToken(
        credDataValue: String,
        credType: String,
        txnId: String,
        referenceId:String?,
        callback: ApiBaseCallback
    ) {
        val headers = commonHeaders.getAuthTokenHeaders()
        val request = UPITokenRequest(credDataValue, credType, txnId, UPIConstants.UPI_TOKEN_TXN_TYPE,referenceId = referenceId).getJSONObject().toString()
        upiCoreApiService.getUPIToken(headers, request, object :
            PayUAsyncTaskResponse {
            override fun onSuccess(response: Any) {
                getResponse(response, callback) {
                    try {
                        val tokenRes = UPITokenResponse.getUPITokenResponseFromJSON(it)
                        sendSuccessCallback(callback, tokenRes.result.token ?: "")
                    }
                    catch (e: Exception){
                        sendFailureCallback(callback,PAYU_FAILED_STATUS,
                            e.message.toString()
                        )
                    }
                }
            }

            override fun onFailure(errorCode: Int, errorMessage: String) {
                sendFailureCallback(callback, errorCode, errorMessage)
            }
        })
    }

    fun getListKeys(
        credDataValue: String,
        credType: String,
        txnId: String,
        referenceId:String?,
        callback: ApiBaseCallback
    ) {
        val headers = commonHeaders.getAuthTokenHeaders()
        val request = UPITokenRequest(credDataValue, credType, txnId, UPIConstants.LIST_KEYS_TXN_TYPE,referenceId = referenceId).getJSONObject().toString()
        upiCoreApiService.getListKeys(headers, request, object:
            PayUAsyncTaskResponse {
            override fun onSuccess(response: Any) {
                getResponse(response, callback) {
                    try {
                        val listKeysResponse = ListKeysResponse.getListKeysResponseFromJSON(it)
                        sendSuccessCallback(callback, listKeysResponse)
                    }
                    catch (e: Exception){
                        sendFailureCallback(callback,PAYU_FAILED_STATUS,
                            e.message.toString()
                        )
                    }
                }
            }

            override fun onFailure(errorCode: Int, errorMessage: String) {
                sendFailureCallback(callback, errorCode, errorMessage)
            }
        })
    }
}